function vcov = project(vcov0,sel)
% Note: If the covariance matrix is not positive definite,
% replace it with the nearest matrix that is positive definite

% sel = 0 : for filtering, sel = 1 : for smoothing
if sel == 0
    e_min=sqrt(eps);
    e_max=1/e_min;
elseif sel == 1
    e_min=1.0e-3;
    e_max=1/e_min;
end
    

vcov=.5*(vcov0+vcov0.');

% [V,D] = eig(vcov);
[V,D,W] = svd(vcov);
% d=diag(V'*vcov*V);
% D=D*spdiags(sign(d.*diag(D)),0,size(V,2),size(V,2));
D = D.*sign(diag(real(dot(V,W,1))));
% [V,D]=schur(vcov);

oldD=diag(D);

% quick exit
%------------
if any(oldD<e_min)||any(oldD>e_max)
    D=max(oldD,e_min);
    D=min(D,e_max);
    vcov = V*diag(D)*V';
end

end
